#ifndef WORKSPACE_H
#define WORKSPACE_H
#include <sndfile.h>
#include "array.h"

/* The s_workspace is to hold arrays for the short window analysis.
 * This way we can put the short window routines in a separate
 * function without having to allocate new space each time and without
 * depending on the sample size not changing.  The sample size is
 * constant for a given sample rate (e.g. 44100Hz), but it would be
 * nice to be able to run this program on multiple files.
*/
typedef struct 
{
  int N;
  int_array signal_int;
  real_array signal_real;
  real_array freq;
  real_array power;
  real_array logscale;
  double logscale_sum, inverse_logscale_sum;
  double uniformity_scale;  /* == log( power->size ), cached here */
  rfftw_plan plan;
} s_workspace;

/* medium window workspace */
typedef struct 
{
  int_array loudness;
  int_array centroid;
  int_array bandwidth;
  int_array uniformity;
  int_array loudness_diff;
  int_array centroid_diff;
  int_array bandwidth_diff;
  int_array uniformity_diff;
} m_workspace;

/* long window (entire file) workspace */
typedef struct 
{
  float_array loudness_mean;
  float_array loudness_std;

  float_array centroid_mean;
  float_array centroid_std;
  float_array bandwidth_mean;
  float_array bandwidth_std;
  float_array uniformity_mean;
  float_array uniformity_std;

  float_array centroid_wmean;
  float_array centroid_wstd;
  float_array bandwidth_wmean;
  float_array bandwidth_wstd;
  float_array uniformity_wmean;
  float_array uniformity_wstd;

  float_array loudness_diff_mean;
  float_array loudness_diff_std;
  float_array centroid_diff_mean;
  float_array centroid_diff_std;
  float_array bandwidth_diff_mean;
  float_array bandwidth_diff_std;
  float_array uniformity_diff_mean;
  float_array uniformity_diff_std;
} l_workspace;

typedef struct 
{
  SF_INFO *sfinfo;
  SNDFILE *inputFile;
  s_workspace sw;
  m_workspace mw;
  l_workspace lw;
} workspace;

void init_workspace( workspace *w, SNDFILE *inputFile, SF_INFO *sfinfo );
void free_workspace( workspace *w );

#endif
