/* short.h */
#ifndef SHORT_H
#define SHORT_H

#include <sndfile.h>
#include "workspace.h"

/************************************
 * SWPS == Short Windows Per Second 
 *
 * SWPS should be in the range [25,40] (as a perceptually reasonable
 * compromise between time and frequency resolution; see Wold '96)
 *
 * and (samplerate / SWPS) should yield a product of small primes
 * (2,3,5,7) because that makes the FFT faster.  Obviously, this
 * depends on samplerate, but most samples use 44100Hz.  30 is a fine
 * value for 22050Hz also, and is terrible for 11025 (25 and 35 are
 * better for that).
*/
#define SWPS 30


void init_s_workspace( s_workspace *sw, SF_INFO *sfinfo );
void free_s_workspace( s_workspace *sw );
int find_short_stats( workspace *w, int *loudnessp, int *centroidp, 
                      int *bandwidthp, int *uniformityp );

#endif
