/* medium.h */
#ifndef MEDIUM_H
#define MEDIUM_H

#include "workspace.h"

/************************************
 * SWPMS == Short Windows Per Medium Window
 * 
 * Measurements are analyzed in medium-length window segments,
 * such as 4 seconds (120 short windows).
 */
#define SWPMW 120


typedef struct
{
  float loudness_mean;
  float loudness_std;

  float centroid_mean;
  float centroid_std;
  float bandwidth_mean;
  float bandwidth_std;
  float uniformity_mean;
  float uniformity_std;

  float centroid_wmean;
  float centroid_wstd;
  float bandwidth_wmean;
  float bandwidth_wstd;
  float uniformity_wmean;
  float uniformity_wstd;

  float loudness_diff_mean;
  float loudness_diff_std;
  float centroid_diff_mean;
  float centroid_diff_std;
  float bandwidth_diff_mean;
  float bandwidth_diff_std;
  float uniformity_diff_mean;
  float uniformity_diff_std;
} m_stats;

void init_m_workspace( m_workspace *mw );
void free_m_workspace( m_workspace *mw );
int find_medium_stats( workspace *w, m_stats *mstat );

#endif
