/*
  main.c
  Copyright 2000, Seth Golub <seth@aigeek.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307,
  USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sndfile.h>
#include <rfftw.h>
#include <unistd.h>
#include "workspace.h"
#include "long.h"
#include "error.h"

void usage( char *argv0 )
{
  fprintf( stderr, "\nUsage: %s [options] file
  Options:
    -h        Display this help
    -v        Verbose\n\n", argv0 );
  exit( ERR_USAGE );
}

int main( int argc, char *argv[] )
{
  SNDFILE *inputFile;
  SF_INFO sfinfo;
  workspace w;
  l_stats lstats;
  int optret;
  int verbose = 0;

  while ( (optret = getopt( argc, argv, "hv" )) != -1 )
    {
      switch ( optret )
        {
          case ':': /* missing parameter */
          case '?': /* unknown option char */
          case 'h': /* help */
            usage( argv[0] );
          case 'v': /* verbose */
            verbose = 1;
            break;
        }
    }
  

  if ( (argc - optind) < 1 )
    {
      fprintf( stderr, "No input file specified.\n" );
      usage( argv[0] );
    }

  inputFile = sf_open_read( argv[optind], &sfinfo );
  if ( inputFile == NULL )
    {
      fprintf( stderr, "%s: Can't open file: %s.\n", argv[0], argv[optind] );
      exit( ERR_OPEN );
    }

  if ( sfinfo.channels != 1 && sfinfo.channels != 2 )
    {
      fprintf( stderr, "%s: Strange number of channels: %d.\n", 
               argv[0], sfinfo.channels );
      exit( ERR_CHANNELS );
    }

  init_workspace( &w, inputFile, &sfinfo );

  find_long_stats( &w, &lstats );

  if ( verbose )
    print_long_stats_verbose( &lstats );
  else
    print_long_stats( &lstats );
  
  free_workspace( &w );
  sf_close( inputFile );
  return 0;
}
