/* long.h */
#ifndef LONG_H
#define LONG_H

#include <sndfile.h>
#include "workspace.h"

typedef struct
{
  int loudness_mean_mean, loudness_mean_std;
  int loudness_std_mean, loudness_std_std;

  int centroid_mean_mean, centroid_mean_std;
  int centroid_std_mean, centroid_std_std;
  int bandwidth_mean_mean, bandwidth_mean_std;
  int bandwidth_std_mean, bandwidth_std_std;
  int uniformity_mean_mean, uniformity_mean_std;
  int uniformity_std_mean, uniformity_std_std;

  int centroid_wmean_mean, centroid_wmean_std;
  int centroid_wstd_mean, centroid_wstd_std;
  int bandwidth_wmean_mean, bandwidth_wmean_std;
  int bandwidth_wstd_mean, bandwidth_wstd_std;
  int uniformity_wmean_mean, uniformity_wmean_std;
  int uniformity_wstd_mean, uniformity_wstd_std;

  int loudness_diff_mean_mean, loudness_diff_mean_std;
  int loudness_diff_std_mean, loudness_diff_std_std;
  int centroid_diff_mean_mean, centroid_diff_mean_std;
  int centroid_diff_std_mean, centroid_diff_std_std;
  int bandwidth_diff_mean_mean, bandwidth_diff_mean_std;
  int bandwidth_diff_std_mean, bandwidth_diff_std_std;
  int uniformity_diff_mean_mean, uniformity_diff_mean_std;
  int uniformity_diff_std_mean, uniformity_diff_std_std;
  float loudness_scale_factor;
  int length;
} l_stats;

void init_l_workspace( l_workspace *lw, SF_INFO *sfinfo );
void free_l_workspace( l_workspace *lw );
void find_long_stats( workspace *w, l_stats *lstat );
void print_long_stats( l_stats *lstat );
void print_long_stats_verbose( l_stats *lstat );

#endif
