/* array.h */
#ifndef ARRAY_H
#define ARRAY_H
#include <rfftw.h>

typedef struct real_array_struct
{
  fftw_real *data;
  int size;
} *real_array;

typedef struct int_array_struct
{
  int *data;
  int size;
} *int_array;

typedef struct float_array_struct
{
  float *data;
  int size;
} *float_array;

int_array new_int_array( int size );
real_array new_real_array( int size );
float_array new_float_array( int size );

void free_int_array( int_array arr );
void free_real_array( real_array arr );
void free_float_array( float_array arr );

long sum( int_array array );
int mean_log2_abs( int_array array );
float mean( int_array arr );
float std( int_array arr, float mean );
float wmean( int_array arr, int_array weights, long weightsum );
float wstd( int_array arr, float mean, int_array weights, long weightsum );
float meanf( float_array arr );
float stdf( float_array arr, float mean );
float stdr( real_array arr, fftw_real mean );

#endif
